#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ProlongedTransfusionReport : BaseTest 
	{
		ProlongedTransfusionReport _testReport;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();
			_testReport = new ProlongedTransfusionReport();
		}

		[TearDown]
		protected void TearDown()
		{
			_testReport = null;
		}

		[Test]
		public void Ctor_Pass_1()
		{
			Assert.IsNotNull( _testReport );
		}

		[Test]
		public void Ctor_Pass_2()
		{
			Assert.AreEqual( COMMON.ProlongedTransfusionTimeReportSortOrder.ReverseChronological, _testReport.SortOrder );
		}
		
		[Test]
		public void Ctor_Pass_3()
		{
			Assert.AreEqual( 0, _testReport.BrokenRulesCount );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.ParameterlessMethod ) ]
		public void Ctor_Fail() {}

		[Test]
		public void GetReportData_Pass_1()
		{
			_testReport.StartDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddYears( -100 );
			_testReport.EndDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();

			Assert.IsNotNull( _testReport.GetReportData() );
		}

		[Test]
		[ExpectedException( typeof(BusinessObjectException) )]
		public void GetReportData_Fail()
		{
			MakeDateRangeInvalidTestObject();
			_testReport.GetReportData();
		}

		[Test]
		public void SortOrder_Pass()
		{
			_testReport.SortOrder = COMMON.ProlongedTransfusionTimeReportSortOrder.IssueToLocation;

			Assert.AreEqual( COMMON.ProlongedTransfusionTimeReportSortOrder.IssueToLocation, _testReport.SortOrder );
		}

		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void SordOrder_Fail(){}

		[Test]
		public void GetRecordCountEstimate_Pass()
		{
			Assert.IsTrue( _testReport.GetRecordCountEstimate() >= 0 );
		}

		[Test]
		[ExpectedException( typeof(BusinessObjectException) )]
		public void GetRecordCountEstimate_Fail()
		{
			MakeDateRangeInvalidTestObject();
			_testReport.GetRecordCountEstimate();
		}

		[Test]
		public void GetReportCriteriaText_Pass()
		{
			Assert.IsNotNull( _testReport.GetReportCriteriaText() );
		}

		[Test]
		[ExpectedException( typeof(BusinessObjectException) )]
		public void GetReportCriteriaText_Fail() 
		{
			MakeDateRangeInvalidTestObject();
			_testReport.GetReportCriteriaText();
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Pass() 
		{
			// It's not possible to test printing from unit test.
		}

		[Test]
		[Ignore(StandardIgnoreReasons.Untestable)]
		public void GenerateAndPrintReport_Fail() 
		{
			// It's not possible to test printing from unit test.
		}

		private void MakeDateRangeInvalidTestObject()
		{
			_testReport.StartDate = _testReport.EndDate.AddYears( 1 );
		}
	}
}
#endif
